<?php
define("AUTH_PASS", "6249"); // change password
define("QTY_FILE", __DIR__ . "/channel_qty.php");
define("SERVICES_FILE", __DIR__ . "/services.php");

session_start();

// ---- LOGIN CHECK ----
if (!isset($_SESSION["logged_in"])) {
    if (!empty($_POST["password"])) {
        if ($_POST["password"] === AUTH_PASS) {
            $_SESSION["logged_in"] = true;
            header("Location: " . $_SERVER["PHP_SELF"]);
            exit;
        } else {
            echo "<h3>❌ Wrong Password</h3>";
        }
    }
    echo '<form method="post" style="max-width:320px;margin:50px auto;font-family:Arial">
            <input type="password" name="password" placeholder="Enter Password" style="width:100%;padding:10px;margin-bottom:10px">
            <button type="submit" style="width:100%;padding:10px;background:#007bff;color:#fff;border:none">Login</button>
          </form>';
    exit;
}

// ---- LOAD CONFIG ----
$data = file_exists(QTY_FILE) ? include(QTY_FILE) : [];
$services = file_exists(SERVICES_FILE) ? include(SERVICES_FILE) : [];

// ---- SAVE CONFIG ----
if (isset($_POST["save"])) {
    // Save channel × service qty
    $newData = [];
    if (!empty($_POST['qty']) && is_array($_POST['qty'])) {
        foreach ($_POST['qty'] as $channel => $sv) {
            $c = trim($channel);
            if ($c === "") continue;
            foreach ($sv as $srvId => $val) {
                $q = intval($val);
                if ($q > 0) {
                    if (!isset($newData[$c])) $newData[$c] = [];
                    $newData[$c][intval($srvId)] = $q;
                }
            }
        }
    }

    if (!empty($_POST['channel_new']) && is_array($_POST['channel_new'])) {
        foreach ($_POST['channel_new'] as $i => $chanName) {
            $c = trim($chanName);
            if ($c === "") continue;
            foreach ($services as $srv) {
                $sid = $srv['id'];
                $val = isset($_POST['qty_new'][$sid][$i]) ? intval($_POST['qty_new'][$sid][$i]) : 0;
                if ($val > 0) {
                    if (!isset($newData[$c])) $newData[$c] = [];
                    $newData[$c][intval($sid)] = $val;
                }
            }
        }
    }

    file_put_contents(QTY_FILE, "<?php\nreturn " . var_export($newData, true) . ";\n");
    $data = $newData;

    // Save services
    $newServices = [];
    if (!empty($_POST['service_id']) && is_array($_POST['service_id'])) {
        foreach ($_POST['service_id'] as $i => $sid) {
            $s = intval($sid);
            $q = isset($_POST['service_qty'][$i]) ? intval($_POST['service_qty'][$i]) : 0;
            if ($s > 0 && $q > 0) $newServices[] = ['id'=>$s,'qty'=>$q];
        }
        file_put_contents(SERVICES_FILE, "<?php\nreturn " . var_export($newServices, true) . ";\n");
        $services = $newServices;
    }

    echo "<div style='color:green;font-family:Arial;text-align:center;padding:10px'>✅ Saved successfully!</div>";
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Channel × Service Qty Manager</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: Arial, sans-serif; background:#f4f4f4; padding:18px; margin:0 }
    h2,h3 { text-align:center; margin-bottom:12px }
    .card { max-width:1000px; margin:12px auto; background:#fff; border-radius:8px; padding:12px; box-shadow:0 2px 6px rgba(0,0,0,0.08) }
    .table-wrap { overflow:auto; max-width:100%; }
    table { width:100%; border-collapse:collapse; min-width:720px }
    th, td { border:1px solid #e6e6e6; padding:8px; text-align:left; }
    th { background:#fafafa; font-weight:600 }
    input[type=text], input[type=number] { width:100%; padding:6px; box-sizing:border-box; border:1px solid #ddd; border-radius:4px }
    .btn { background:#28a745; color:#fff; padding:8px 12px; border:none; border-radius:6px; cursor:pointer; margin:4px; }
    .btn.add { background:#007bff }
    @media (max-width:700px){ table{min-width:600px} }
  </style>
</head>
<body>
<h2>📊 Channel × Service Qty Manager</h2>

<!-- CHANNEL × SERVICE QTY -->
<div class="card">
<form method="post">
  <div class="table-wrap">
    <table>
      <tr>
        <th>Channel Username / ID</th>
        <?php foreach($services as $s): ?>
          <th>Service <?=htmlspecialchars($s['id'])?><br><small>def <?=htmlspecialchars($s['qty'])?></small></th>
        <?php endforeach; ?>
      </tr>

      <?php foreach($data as $channel => $sv): ?>
        <tr>
          <td><input type="text" name="channel_display[]" value="<?=htmlspecialchars($channel)?>" readonly></td>
          <?php foreach($services as $s): $sid=$s['id']; ?>
            <td><input type="number" name="qty[<?=htmlspecialchars($channel)?>][<?=htmlspecialchars($sid)?>]" value="<?=isset($sv[$sid])?$sv[$sid]:""?>"></td>
          <?php endforeach; ?>
        </tr>
      <?php endforeach; ?>

      <tr>
        <td><input type="text" name="channel_new[]" placeholder="new channel"></td>
        <?php foreach($services as $s): $sid=$s['id']; ?>
          <td><input type="number" name="qty_new[<?=htmlspecialchars($sid)?>][]" placeholder="qty"></td>
        <?php endforeach; ?>
      </tr>
    </table>
  </div>
  <br>
  <div style="text-align:center">
    <button type="submit" name="save" class="btn">💾 Save</button>
    <button type="button" onclick="addRow()" class="btn add">➕ Add Row</button>
  </div>

  <!-- --- SERVICES EDIT SECTION --- -->
  <div class="section card">
    <h3>⚙️ Edit / Add Services</h3>
    <div class="table-wrap">
      <table id="servicesTable">
        <tr><th>Service ID</th><th>Default Qty</th></tr>
        <?php foreach($services as $s): ?>
        <tr>
          <td><input type="number" name="service_id[]" value="<?=htmlspecialchars($s['id'])?>"></td>
          <td><input type="number" name="service_qty[]" value="<?=htmlspecialchars($s['qty'])?>"></td>
        </tr>
        <?php endforeach; ?>
        <tr>
          <td><input type="number" name="service_id[]" placeholder="new service id"></td>
          <td><input type="number" name="service_qty[]" placeholder="default qty"></td>
        </tr>
      </table>
    </div>
    <br>
    <div style="text-align:center">
      <button type="submit" name="save" class="btn">💾 Save</button>
      <button type="button" onclick="addServiceRow()" class="btn add">➕ Add Service</button>
    </div>
  </div>

</form>
</div>

<script>
function addRow(){
  var table=document.querySelector("form > .table-wrap > table");
  var tr=document.createElement("tr");
  var html='<td><input type="text" name="channel_new[]" placeholder="new channel"></td>';
  <?php foreach($services as $s): $sid=$s['id']; ?>
    html+='<td><input type="number" name="qty_new[<?=$sid?>][]" placeholder="qty"></td>';
  <?php endforeach; ?>
  tr.innerHTML=html;
  table.appendChild(tr);
}

function addServiceRow(){
  var table=document.getElementById("servicesTable");
  var tr=document.createElement("tr");
  tr.innerHTML='<td><input type="number" name="service_id[]" placeholder="new service id"></td>'+
               '<td><input type="number" name="service_qty[]" placeholder="default qty"></td>';
  table.appendChild(tr);
}
</script>
</body>
</html>