<?php
// notify_due.php
date_default_timezone_set('Asia/Kolkata');

$data_file = __DIR__ . '/data/customers.json';

// === CONFIG: your bot token & chat id (you provided these) ===
$telegram_token = '8018087419:AAE_VAhC48k5Zl7RoVAMyy1Q6qbtryaVQ_g';
$telegram_chat_id = '-1002984572142';

// Read data
if (!file_exists($data_file)) {
    // nothing to do
    exit;
}
$json = @file_get_contents($data_file);
$data = json_decode($json, true);
if (!is_array($data)) $data = [];

$now = new DateTime('now', new DateTimeZone('Asia/Kolkata'));
$changed = false;

foreach ($data as $idx => $rec) {
    // skip if already notified
    if (!empty($rec['notified'])) continue;
    if (empty($rec['due_date'])) continue;

    // Parse stored due_date (we stored as 'Y-m-d H:i:s' in IST)
    $due = DateTime::createFromFormat('Y-m-d H:i:s', $rec['due_date'], new DateTimeZone('Asia/Kolkata'));
    if (!$due) {
        // try alternative parse
        $due = new DateTime($rec['due_date'], new DateTimeZone('Asia/Kolkata'));
    }
    if (!$due) continue;

    // If due <= now, send notification
    if ($due <= $now) {
        $message = "🔔 *Subscription Due*\n";
        $message .= "*Name:* " . escape_markdown($rec['customer_name'] ?? '') . "\n";
        if (!empty($rec['subscription_time'])) $message .= "*Subscription:* " . escape_markdown($rec['subscription_time']) . "\n";
        $message .= "*Due Date (IST):* " . $due->format('Y-m-d H:i') . "\n";
        if (!empty($rec['note'])) $message .= "*Note:* " . escape_markdown($rec['note']) . "\n";
        $message .= "\nID: " . ($rec['id'] ?? '');

        $sent = send_telegram_message($telegram_token, $telegram_chat_id, $message);
        if ($sent) {
            $data[$idx]['notified'] = true;
            $changed = true;
        } else {
            error_log("notify_due: failed to send for id " . ($rec['id'] ?? ''));
        }
    }
}

if ($changed) {
    // Save back
    $tmp = $data_file . '.tmp';
    file_put_contents($tmp, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE), LOCK_EX);
    rename($tmp, $data_file);
}

function send_telegram_message($token, $chat_id, $message) {
    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    $resp = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch);
    curl_close($ch);
    if ($resp === false || $http != 200) {
        error_log("Telegram send error: HTTP {$http} - {$err} - resp: " . substr($resp,0,200));
        return false;
    }
    $j = json_decode($resp, true);
    return isset($j['ok']) && $j['ok'] === true;
}

function escape_markdown($text) {
    if ($text === null) return '';
    $chars = ['_', '*', '[',']','(',')','~','`','>','#','+','-','=','|','{','}','.', '!'];
    return str_replace($chars, array_map(function($c){return "\\".$c;}, $chars), $text);
}